﻿Public Class Preferences

    Public Shared Pref_GridBackgroundColor As System.Drawing.Color = Color.Gray
    Public Shared Pref_GridForegroundColor As System.Drawing.Color = Color.Black
    Public Shared Pref_GridSelectionColor As System.Drawing.Color = Color.WhiteSmoke
    Public Shared Pref_FrameSkip20 As Integer = 0
    Public Shared Pref_FrameSkip40 As Integer = 0
    Public Shared Pref_FrameSkip80 As Integer = 0

    Private Sub BCOTG_ResetButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BCOTG_ResetButton.Click
        BCOTG_preview.BackColor = Color.Gray
    End Sub
    Private Sub FCOTG_ResetButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FCOTG_ResetButton.Click
        FCOTG_preview.BackColor = Color.Black
    End Sub
    Private Sub SCOTG_ResetButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SCOTG_ResetButton.Click
        SCOTG_preview.BackColor = Color.WhiteSmoke
    End Sub

    Private Sub BCOTG_SelectButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BCOTG_SelectButton.Click
        Dim X As New ColorDialog
        If X.ShowDialog = Windows.Forms.DialogResult.OK Then
            BCOTG_preview.BackColor = X.Color
        End If
    End Sub
    Private Sub FCOTG_SelectButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FCOTG_SelectButton.Click
        Dim X As New ColorDialog
        If X.ShowDialog = Windows.Forms.DialogResult.OK Then
            FCOTG_preview.BackColor = X.Color
        End If
    End Sub
    Private Sub SCOTG_SelectButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SCOTG_SelectButton.Click
        Dim X As New ColorDialog
        If X.ShowDialog = Windows.Forms.DialogResult.OK Then
            SCOTG_preview.BackColor = X.Color
        End If
    End Sub

    Private Sub SaveButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveButton.Click
        Try
            System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\settings\pref_gridbackgroundcolor.cfg", BCOTG_preview.BackColor.ToArgb.ToString, System.Text.Encoding.Default)
            Pref_GridBackgroundColor = BCOTG_preview.BackColor
        Catch Ex As Exception
            MsgBox("Unable to save all settings!" + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
        End Try

        Try
            System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\settings\pref_gridforegroundcolor.cfg", FCOTG_preview.BackColor.ToArgb.ToString, System.Text.Encoding.Default)
            If Pref_GridForegroundColor <> FCOTG_preview.BackColor Then
                Pref_GridForegroundColor = FCOTG_preview.BackColor
                Main.IMG_Grid = EditorResources.DrawGrid(False)
                Main.IMG_GridWithID = EditorResources.DrawGrid(True)
                Main.Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
            End If
            Pref_GridForegroundColor = FCOTG_preview.BackColor
        Catch Ex As Exception
            MsgBox("Unable to save all settings!" + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
        End Try

        Try
            System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\settings\pref_gridselectioncolor.cfg", SCOTG_preview.BackColor.ToArgb.ToString, System.Text.Encoding.Default)
            Pref_GridSelectionColor = SCOTG_preview.BackColor
            Main.IMG_Cursor = EditorResources.CreateSelectionMapEditorBox
        Catch Ex As Exception
            MsgBox("Unable to save all settings!" + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
        End Try

        Try
            System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\settings\pref_gridbackgroundcolor.cfg", BCOTG_preview.BackColor.ToArgb.ToString, System.Text.Encoding.Default)
            Pref_GridBackgroundColor = BCOTG_preview.BackColor
        Catch Ex As Exception
            MsgBox("Unable to save all settings!" + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
        End Try

        Try
            System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\settings\pref_frameskip20.cfg", SkipOf20.Value.ToString, System.Text.Encoding.Default)
            Pref_FrameSkip20 = SkipOf20.Value
        Catch Ex As Exception
            MsgBox("Unable to save all settings!" + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
        End Try

        Try
            System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\settings\pref_frameskip40.cfg", SkipOf40.Value.ToString, System.Text.Encoding.Default)
            Pref_FrameSkip40 = SkipOf40.Value
        Catch Ex As Exception
            MsgBox("Unable to save all settings!" + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
        End Try

        Try
            System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\settings\pref_frameskip80.cfg", SkipOf80.Value.ToString, System.Text.Encoding.Default)
            Pref_FrameSkip80 = SkipOf80.Value
        Catch Ex As Exception
            MsgBox("Unable to save all settings!" + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
        End Try

        Main.ChangeFrameSkip() 'Update frame skip
        Me.Close()
    End Sub

    Private Sub Peferences_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        BCOTG_preview.BackColor = Pref_GridBackgroundColor
        FCOTG_preview.BackColor = Pref_GridForegroundColor
        SCOTG_preview.BackColor = Pref_GridSelectionColor
        SkipOf20.Value = Pref_FrameSkip20
        SkipOf40.Value = Pref_FrameSkip40
        SkipOf80.Value = Pref_FrameSkip80
    End Sub

    Private Sub CancelButton1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CancelButton1.Click
        Me.Close()
    End Sub


    Private Sub ResetFrameSkip_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetFrameSkip.Click
        SkipOf20.Value = 0
        SkipOf40.Value = 0
        SkipOf80.Value = 0
    End Sub

End Class